<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # Database conversion from vbbanners 1.x product                         # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008 - All Rights Reserved.          # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008 - All Rights Reserved
 * @version 2.0.0
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);
define('CVS_REVISION', '$RCSfile$ - $Revision: 1 $');

$phrasegroups = array();
$specialtemplates = array();

require_once './global.php';

// #############################################################################
// ######################### START MAIN SCRIPT #################################
// #############################################################################

if(!can_administer('canadminmaintain'))
{
    print_cp_no_permission();
}

log_admin_action();

print_cp_header('vBBanner Tables Conversion');

// Read date values to convert 
$recs = array();
$SQL = "SELECT id, startdate, enddate 
    FROM " . TABLE_PREFIX . "banners";
$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    $a = explode('-', $rs['startdate']);
    $recs[$rs['id']]['startdate'] = mktime(0, 0, 0, $a[1], $a[2], $a[0]);
    $a = explode('-', $rs['enddate']);
    $recs[$rs['id']]['enddate'] = mktime(0, 0, 0, $a[1], $a[2], $a[0]);
}
$vbulletin->db->free_result($rss);

// Convert table
$SQL = array();
$SQL[] = "RENAME TABLE " . TABLE_PREFIX . "banners 
    TO " . TABLE_PREFIX . "rbs_banners";

// Convert fields
$SQL[] = "ALTER TABLE " . TABLE_PREFIX . "rbs_banners
    CHANGE `startdate` `startdate` INT UNSIGNED NOT NULL DEFAULT '0'";
$SQL[] = "ALTER TABLE " . TABLE_PREFIX . "rbs_banners
    CHANGE `enddate` `enddate` INT UNSIGNED NOT NULL DEFAULT '0'";

// Create updates
foreach($recs as $key => $value)
{
    $SQL[] = "UPDATE " . TABLE_PREFIX . "rbs_banners 
        SET startdate=$value[startdate], enddate=$value[enddate] 
        WHERE id=$key";
}

// Drop old tables
$SQL[] = "DROP TABLE IF EXISTS " . TABLE_PREFIX . "banners";
$SQL[] = "DROP TABLE IF EXISTS " . TABLE_PREFIX . "banneruser";

// Do it all
foreach($SQL as $value)
{
    if(strpos($value, 'ALTER TABLE ') !== false)
    {
        $vbulletin->db->hide_errors();
        $vbulletin->db->query_write($value);
        $vbulletin->db->hide_errors();
    }
    else
    {
        $vbulletin->db->query_write($value);
    }
}

echo 'vBBanner Tables Converted<br /><br />';
echo 'You may now remove this script and install the product.';

print_cp_footer();
?>